/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.regionalsettings;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.StringParser;
import cz.insophy.inplan.util.regionalsettings.XmlRegionalSettings;
import cz.insophy.inplan.util.xml.JaxbXmlReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionalSettings {
    private static final Logger log = LoggerFactory.getLogger(RegionalSettings.class);
    private final URL scheme;
    private final Path cfgFile;

    public static void initializeFromFile(@Nonnull Path cfgFilePath) {
        RegionalSettings regionalSettings = new RegionalSettings(cfgFilePath);
        regionalSettings.read().ifPresentOrElse(RegionalSettings::setRegions, () -> {
            log.error("Regional settings XML not loaded, using legacy settings");
            RegionalSettings.setRegions(regionalSettings.createLegacyRegions());
        });
    }

    private static void setRegions(@Nonnull XmlRegionalSettings regions) {
        Preconditions.checkNotNull(regions);
        Formatter.setRegions(regions);
        StringParser.setRegions(regions);
    }

    public RegionalSettings(@Nonnull Path cfgFile) {
        Preconditions.checkNotNull(cfgFile);
        this.cfgFile = cfgFile;
        this.scheme = this.getClass().getResource("regional-settings.xsd");
        Preconditions.checkNotNull(this.scheme);
    }

    public RegionalSettings() {
        this.cfgFile = null;
        this.scheme = this.getClass().getResource("regional-settings.xsd");
        Preconditions.checkNotNull(this.scheme);
    }

    public Optional<XmlRegionalSettings> read() {
        JaxbXmlReader<XmlRegionalSettings> reader = new JaxbXmlReader<XmlRegionalSettings>(XmlRegionalSettings.class, this.scheme);
        Optional<XmlRegionalSettings> oRegions = reader.read(this.cfgFile);
        if (oRegions.isEmpty()) {
            log.error("Failed to read regional settings file: {}", (Object)reader.getLastError());
        }
        return oRegions;
    }

    public XmlRegionalSettings createLegacyRegions() {
        JaxbXmlReader<XmlRegionalSettings> reader = new JaxbXmlReader<XmlRegionalSettings>(XmlRegionalSettings.class, this.scheme);
        Optional<XmlRegionalSettings> oRegions = reader.read(Objects.requireNonNull(this.getClass().getResource("default_regional_settings.xml")));
        return oRegions.get();
    }

    public record RegionExample(@Nonnull String name, @Nonnull String value) {
    }
}

